function [GN, x_new] = bevTransmLogic(x, prof, dyn, veh)
%bevTransmLogic PEV transmission logic from VECTO

gbCtrl = veh.gb.ctrl;

% States
lastDownshiftTime = x{1};
lastUpshiftTime = x{2};

% Other inputs
GN_prev = prof.gearNumber;
emSpd = prof.emSpd;
emTrq = prof.emTrq;
time = prof.time;

emMaxTrq = veh.em.maxTrq(emTrq);
emMinTrq = veh.em.minTrq(emTrq);

maxGear = length(veh.gb.gear);

% General requirements for shifting
lastShift = max(lastDownshiftTime, lastUpshiftTime);

downshiftReq = ( time > (lastShift + gbCtrl.shiftMinTime) ) & ( time > (lastUpshiftTime + gbCtrl.downshiftDelay) ) & ( GN_prev > 1 );
upshiftReq = ( time > (lastShift + gbCtrl.shiftMinTime) ) & ( time > (lastDownshiftTime + gbCtrl.upshiftDelay) ) & ( dyn.vehAcc >= 0 ) & ( GN_prev < maxGear );

%%%%
% gbCtrl.n_P80 = em.maxSpd;
% gbCtrl.n_max = em.maxSpd;
% gbCtrl.n_rated = em.maxSpd;

%%%%

%% Vehicle start
if ( GN_prev == 0 ) && ( dyn.vehAcc > 0 )
    % Emergency upshift
    GN = GN_prev + 1;
    lastUpshiftTime = time;
    updateState
    return
end

%% Emergency shifts
% TODO Shift to neutral %
if ( GN_prev < maxGear ) && ( emSpd > gbCtrl.n_max )
    % Emergency upshift
    GN = GN_prev + 1;
    lastUpshiftTime = time;
    updateState
    return
end

%% Polygon shifts
if downshiftReq
    if ( emSpd < 0.1 * gbCtrl.n_rated )
        GN = GN_prev - 1;
        lastDownshiftTime = time;
        updateState
        return
    else
        if ( emTrq >= 0 ) && ( emSpd < gbCtrl.n_P80h ) && ( emTrq > 0.9 * emMaxTrq )
            GN = GN_prev - 1;
            lastDownshiftTime = time;
            updateState
            return
        elseif ( emSpd < gbCtrl.n_rated ) && ( emTrq < 0.9 * emMinTrq )
            GN = GN_prev - 1;
            lastDownshiftTime = time;
            updateState
            return
        end
    end
end

if upshiftReq
    if ( emSpd > 0.9 * gbCtrl.n_max )
        GN = GN_prev + 1;
        lastUpshiftTime = time;
        updateState
        return
    end
end

%% Efficiency shift
% Evaluate GN candidates
if downshiftReq && upshiftReq
    GNset = (-gbCtrl.maxGearSkip:1:gbCtrl.maxGearSkip)' + GN_prev;
elseif downshiftReq && ~upshiftReq
    % Only downshift is possible
    GNset = (-gbCtrl.maxGearSkip:1:0)' + GN_prev;
elseif ~downshiftReq && upshiftReq
    % Only upshift is possible
    GNset = (0:1:gbCtrl.maxGearSkip)' + GN_prev;
else
    % No eff shifting allowed
    GN = GN_prev;
    updateState
    return
end

% Remove GN candidates  < 1 or > the max GN
GNset(GNset<1) = [];
GNset(GNset>maxGear) = [];
[~, ~, prof] = bevModel({GN_prev}, {GNset, 0}, dyn, veh);

battCurrSet = [prof.battCurr];
spdRatioSet = [veh.gb.gear(GNset).spdRatio]';
emPwrSet =  [prof.emSpd] .* [prof.emTrq];
emSpdSet =  [prof.emSpd];
emTrqSet =  [prof.emTrq];

% Requirements:
spdReqDown = spdRatioSet <= ( gbCtrl.ratioEarlyDown / veh.fd.spdRatio );
spdReqUp = spdRatioSet <= ( gbCtrl.ratioEarlyUp / veh.fd.spdRatio );

battCurrCurrentGear = battCurrSet( GNset == GN_prev );
pwrReq = true(size(GNset)); % effUpShiftCond3 = engPwrSet >= engPwr;
fuelReq = battCurrSet < battCurrCurrentGear * gbCtrl.effHyst;

% Apply the torque reserve req if motor and the braking req if generator
trqResReq = 1 - emPwrSet ./ ( veh.em.maxTrq( emSpdSet ) .* emSpdSet ) > gbCtrl.trqRes;
brakReq = emTrqSet > 0.98 .* veh.em.minTrq( emSpdSet );
trqResReq( emTrqSet < 0 ) = brakReq( emTrqSet < 0 );

% Combine all requirements
effReqUp = spdReqUp & trqResReq & pwrReq & fuelReq;
effReqDown = spdReqDown & trqResReq & fuelReq;

% Combine all requirements
effReq = effReqUp;
effReq( GNset < GN_prev ) = effReqDown( GNset < GN_prev );

if any(effReq)
    % Find min current GN
    cost = battCurrSet;
    cost(~effReq) = inf;
    [~, idx] = min( cost );
    GN = GNset(idx);
else
    GN = GN_prev;
end

updateState
return

%% Nested function to update states
    function updateState()
        if GN < GN_prev
            lastDownshiftTime = time;
        elseif GN > GN_prev
            lastUpshiftTime = time;
        end

        x_new{1} = lastDownshiftTime;
        x_new{2} = lastUpshiftTime;
    end

end